using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using System.Collections.Generic;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieProfile
		{
			
			
			public class MovieCastBO : StrataFlix.Business.MovieCastBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("mc_CastTypeText", typeof(MovieCastBO)));
					r.Add(new ReflectionPropertyDescriptor("mc_CharacterNameWithParens", typeof(MovieCastBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// Returns a cast type in text format for grouping
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mc_CastTypeText
				{
					get
					{
						switch (mc_CastType)
						{
							case Business.MovieCastType.Actor:
								return "Actors";
							case Business.MovieCastType.Crew:
								return "Crew";
							case Business.MovieCastType.Director:
								return "Directors";
							case Business.MovieCastType.Producer:
								return "Producers";
							default:
								return MicroFour.StrataFrame.Tools.Common.GetEnumDisplayValue(mc_CastType);
						}
					}
				}
				
				/// <summary>
				/// Returns the character name in parens if specified
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mc_CharacterNameWithParens
				{
					get
					{
						if (mc_CharacterName.Length == 0)
						{
							return "";
						}
						else
						{
							return "(" + mc_CharacterName + ")";
						}
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
